﻿(function ($) {
    $.widget("a4.a4listview", {
        options: {
            expanded: false,
            expandedByDepth: [],
            stateKey: undefined,
            actionButtons: [],
            actionsButtonsDropDown: false,
            displayActionButtonsOnHover: true,
            displayActionButtonsOnSelected: false,
            ajaxAction: undefined,
            ajaxParams: {},
            customItems: undefined,
            icons: {
                Root: undefined,
                Node: { Icon: "fa-folder", SelectedIcon: "fa-folder-open" },
                Leaf: undefined,
                Custom: []
            },
            properties: {
                Key: "Id",
                Id: "Id",
                ParentId: "ParentId",
                Children: "Children",
                Label: "Name"
            },
            displaySearchBox: true,
            multipleSelection: false,
            allowUnselect: false,
            altValueField: undefined //Input element that is to be updated with the selected values from the listview.
                                     // Remove coma at the end ... Uncompatile with compatibilty view
        },
        _create: function () {
            var self = this;
            var loadStateCall = null;

            if (this.options.stateKey) {
                loadStateCall = this._loadState();
            }
            else {
                this.state = { Nodes: [] };
            }

            $.when(loadStateCall).then(function () {
                self._render();

                self._loadServerData();

                self._bindEvents();
            });
        },
        destroy: function () {
            $.Widget.prototype.destroy.call(this);
        },
        getSelectedNode: function () {
            return this.lastSelectedNode;
        },
        getSelectedNodes: function () {
            var self = this;
            var nodes;

            if (this.state.Nodes.length > 0) {
                var nodesState = _.filter(this.state.Nodes, function (n) { return n.Selected == true });

                if (nodesState && nodesState.length > 0) {
                    nodes = _.map(nodesState, function (n) { return self._getNodeData(n.Key); });
                }
            }

            return nodes;
        },
        refresh: function () {
            this._loadServerData();
            this._resetSearch();
        },
        selectFirstRootNode: function () {
            if (this.data.Nodes.length > 0) {
                this._handleNodeClick(_.find(this.data.Nodes, function (n) { return n.ParentId == null; }), false);
            }
        },
        selectSpecificNode: function (nodeKey) {
            this._handleNodeClick(this._getNodeData(nodeKey), false);
        },
        getParentNode: function (node) {
            var parentNode;

            if (node.Id) {
                parentNode = _.find(this.data.Nodes, function (n) { return n.Id == node.ParentId; });
            }

            return parentNode;
        },
        _resetSearch: function () {
            $(".h-searchBox").val('');
        },
        _isExpandedFromDepth: function (depth) {
            var self = this;
            var isExpanded = self.options.expanded;
            if (self.options.expandedByDepth[depth] !== undefined) {
                isExpanded = self.options.expandedByDepth[depth];
            }
            return isExpanded;
        },
        _loadServerData: function () {
            var self = this;

            this.lastSelectedNode = null;

            a4.callServerMethod(self.options.ajaxAction, self.options.ajaxParams, function (result) {
                if (result) {
                    if (result.d) {
                        result = _.isString(result.d) ? JSON.parse(result.d) : result.d;
                    }

                    //Flatten data and initialize internal cache
                    self._initializeNodeData(result);

                    self._renderList(self.data.Nodes);

                    var selectedNodeState = _.find(self.state.Nodes, function (n) { return n.Selected == true });

                    if (selectedNodeState) {
                        self.lastSelectedNode = self._getNodeData(selectedNodeState.Key);
                    }

                    self._trigger("draw", null, { count: self.data.Nodes.length, selectedNode: self.lastSelectedNode });
                }
            }, function (error) { });
        },
        _initializeNodeData: function (nodes) {
            var self = this;

            this.data = { Nodes: [] };

            if (nodes && nodes[0] && typeof nodes[0][self.options.properties.Children] != 'undefined') {
                //Flatten the nodes to store it in internal data
                this.data.Nodes = this._flattenHierarchicalNodeData(nodes);
            }
            else {
                this.data.Nodes = nodes;

                //Populating internal node key property
                _.each(this.data.Nodes, function (n) {
                    self._setNodeInternalKey(n);
                });
            }

            //Add custom items
            if (this.options.customItems && _.isArray(this.options.customItems)) {
                _.each(this.options.customItems, function (n) {
                    n.ListView_Internal_Key = _.uniqueId("custom_");
                    n.ListView_Internal_IsCustom = true;
                });

                self.data.Nodes = _.union(this.options.customItems, self.data.Nodes);
            }

            //Update state to remove deleted nodes
            this.state.Nodes = _.filter(this.state.Nodes, function (n) {
                return _.some(self.data.Nodes, function (x) {
                    return x.ListView_Internal_Key == n.Key;
                });
            });
        },
        _flattenHierarchicalNodeData: function (nodes) {
            if (!nodes || nodes.length == 0)
                return null;

            var self = this;

            //Can it goes inside map?
            _.each(nodes, function (n) {
                self._setNodeInternalKey(n, true);

                _.each(n[self.options.properties.Children], function (c) {
                    c.ListView_Internal_ParentKey = n.ListView_Internal_Key;
                });
            });

            return _.compact(_.flatten(_.union(nodes, _.map(nodes, function (n) {
                return self._flattenHierarchicalNodeData(n[self.options.properties.Children]);
            }))));
        },
        _setNodeInternalKey: function (node, nested) {
            if (node && !node.ListView_Internal_Key) {
                var self = this;
                var keyProperty = this.options.properties.Key;
                var key;

                if (!nested && node.ListView_Internal_ParentKey == null && node[self.options.properties.ParentId] != null) {
                    var parentNode = _.find(self.data.Nodes, function (p) { return p[self.options.properties.Id] == node[self.options.properties.ParentId]; });

                    if (parentNode) {
                        this._setNodeInternalKey(parentNode);
                        node.ListView_Internal_ParentKey = parentNode.ListView_Internal_Key;
                    }
                }

                if (_.isArray(keyProperty)) {
                    key = _.compact(_.map(keyProperty, function (k) { return node[k].toString(); })).join("_");
                }
                else {
                    key = node[keyProperty];
                }

                if (node.ListView_Internal_ParentKey !== undefined) {
                    key = node.ListView_Internal_ParentKey + "_" + key;
                }

                node.ListView_Internal_Key = key;
            }
        },
        _getNodeState: function (key) {
            var nodeState = _.find(this.state.Nodes, function (n) { return n.Key == key; });
            return nodeState;
        },
        _getNodeData: function (key) {
            return _.find(this.data.Nodes, function (n) { return n.ListView_Internal_Key == key; });
        },
        _getRootNodes: function (nodes) {
            var self = this;
            var rootNodes;

            if (nodes && nodes.length > 0) {
                rootNodes = _.filter(nodes, function (n) { return (n.ListView_Internal_ParentKey === undefined)|| !_.some(nodes, function (x) { return n.ListView_Internal_ParentKey == x.ListView_Internal_Key; }); });
            }

            return rootNodes;
        },
        _getParentNode: function (node) {
            var parentNode;

            if (node.ListView_Internal_ParentKey) {
                parentNode = _.find(this.data.Nodes, function (n) { return n.ListView_Internal_Key == node.ListView_Internal_ParentKey; });
            }

            return parentNode;
        },
        _getParentNodes: function (node) {
            var parent = this._getParentNode(node);

            if (parent) {
                return _.union([parent], this._getParentNodes(parent));
            }

            return null;
        },
        _getChildrenNodes: function (nodes, node) {
            var self = this;
            var childrenNodes;

            if (nodes && nodes.length > 0) {
                childrenNodes = _.filter(nodes, function (n) { return n.ListView_Internal_ParentKey !== undefined && node.ListView_Internal_Key == n.ListView_Internal_ParentKey; });
            }

            return childrenNodes;
        },
        _render: function () {
            var container = $("<div />", { "class": "list-view" });

            if (this.options.displaySearchBox) {
                var searchBox = $("<div />", { "class": "search-box" });

                searchBox.append($("<input />", { "type": "search", "class": "h-searchBox", "placeholder": sharedResources["Search"] }));
                searchBox.append($("<span />", { "class": "h-searchButton search-button fa fa-search" }));

                container.append(searchBox);
            }

            container.append($("<div />", { "class": "list-view-message" }).append($("<div />", { "class": "loading-icon" })));

            var content = $("<div />", { "class": "list-view-content" });

            content.hide();

            container.append(content);

            this.element.html(container);
        },
        _renderList: function (nodes, expanded) {
            var self = this;

            var listView = $(".list-view-content", this.element);

            listView.empty();


            if (nodes.length > 0) {
                var rootNodes = self._getRootNodes(nodes);

                if (rootNodes && rootNodes.length != nodes.length) {
                    _.each(rootNodes, function (n) {
                        var subMenu = $("<ul />", { "class": "sub-menu" });
                        self._renderNode(subMenu, nodes, n, 0, expanded);
                        listView.append(subMenu);
                    });
                }
                else {
                    var subMenu = $("<ul />", { "class": "sub-menu" });

                    _.each(rootNodes, function (n) {
                        self._renderNode(subMenu, nodes, n, 0, expanded);
                    });
                }

                listView.append(subMenu);
            }
            else {
                //listView.append($("<div />").append("No items"));

                listView.append($("<ul />", { "class": "sub-menu" }).append($("<li />", { "class": "node message" }).append(dataTableResources.EmptyTable)));
            }

            listView.show();

            $(".list-view-message", this.element).hide();
        },
        _getNodeIcon: function (node, type, selected) {
            var icon;
            var icons = this.options.icons;

            if (icons) {
                if (icons.Custom && _.isArray(icons.Custom) && icons.Custom.length > 0) {
                    icon = _.find(icons.Custom, function (i) { return a4.evaluateCondition(i.Condition, node); });
                }

                if (!icon) {
                    icon = icons[type] || icons["Node"];
                }

                if (icon && _.isObject(icon)) {
                    icon = (selected && icon.SelectedIcon != undefined) ? icon.SelectedIcon : icon.Icon;
                }
            }

            return icon;
        },
        _getNodeLabel: function (node, type) {
            var label;
            var labelProperty = this.options.properties[type] || this.options.properties["Node"];

            if (labelProperty && _.isObject(labelProperty)) {
                label = node[labelProperty.Label];
            }

            if (!label) {
                label = node[this.options.properties.Label];
            }

            return label;
        },
        _renderNode: function (parent, nodes, node, depth, expanded) {
            var self = this;
            var children = self._getChildrenNodes(nodes, node);

            var isRoot = depth == 0;
            var isLeaf = !children || children.length == 0;

            var nodeState = this._getNodeState(node.ListView_Internal_Key);

            if (!nodeState) {
                nodeState = { Key: node.ListView_Internal_Key, Expanded: false, Selected: false };
                this.state.Nodes.push(nodeState);
            }

            expanded = (nodeState.Expanded && isRoot) || this._isExpandedFromDepth(depth);

            var listItemClass = "node";
            var caretImageClass = "h-toggle toggle fa fa-fw";
            var nodeType = "Node";

            if (isRoot) {
                listItemClass += " root";
                nodeType = "Root";
            }
            else if (isLeaf) {
                listItemClass += " leaf";
                nodeType = "Leaf";
            }

            if (expanded) {
                listItemClass += " expanded";
                caretImageClass += " fa-caret-down";
            }
            else {
                caretImageClass += " fa-caret-right";
            }

            if (nodeState.Selected) {
                listItemClass += " selected";
            }

            if (node.ListView_Internal_IsCustom) {
                listItemClass += " custom";
            }

            var listItem = $("<li />", { "class": listItemClass, "data-nodekey": node.ListView_Internal_Key });

            var padding = (depth * 8) + 5;

            if (children.length > 0) {
                listItem.append($("<span />", { "class": caretImageClass }));
            }
            else {
                padding += 18;
            }

            var nodeIcon = this._getNodeIcon(node, nodeType, nodeState.Selected);

            if (nodeIcon) {
                listItem.append($("<span />", { "class": "node-icon v-nodeIcon fa " + nodeIcon }));
            }

            var textSpan = $("<span />", { "class": "text" });

            var label = this._getNodeLabel(node, nodeType)
            if (label.visualLength() > 200) {
                textSpan.attr("title", label);
                label = label.trimToPx(200);
            }
            textSpan.append(label);

            listItem.append(textSpan);

            this._renderActionButtons(node, listItem);

            listItem.css("padding-left", padding);

            parent.append(listItem);

            //Setting jquery element to node data
            node.Element = listItem;

            if (children.length > 0) {
                var subMenu = $("<ul />", { "class": "sub-menu" });

                subMenu.css("display", expanded ? "block" : "none");

                _.each(children, function (n) {
                    subMenu.append(self._renderNode(subMenu, nodes, n, depth + 1, self.options.expanded));
                });

                parent.append(subMenu);
            }
        },
        _renderActionButtons: function (node, listItem) {
            var self = this;

            if (this.options.actionButtons.length > 0) {
                var actionButtonsDiv = $("<div />", { "class": "h-actionButtons" });

                if (this.options.displayActionButtonsOnHover) {
                    actionButtonsDiv.addClass("display-on-hover");
                }

                if (this.options.displayActionButtonsOnSelected) {
                    actionButtonsDiv.addClass("display-on-selected");
                }

                if (this.options.actionsButtonsDropDown) {
                    var buttonGroup = $("<div />", { "class": "button-group" });

                    var button = $("<div />", { "class": "button icon-only dropdown-toggle" });
                    button.append($("<span />", { "class": "fa fa-lg fa-gears" }));
                    button.append($("<span />", { "class": "icon-right fa fa-caret-down" }));

                    var dropDownMenu = $("<ul />", { "class": "dropdown-menu" });

                    _.each(this.options.actionButtons, function (b) {
                        if (a4.evaluateCondition(b.DisplayCondition, node)) {
                            var actionButton = $("<li />", { "data-action": b.Action }).append($("<a />", { "href": "#" }).append(b.Label));

                            dropDownMenu.append(actionButton);
                        }
                    });

                    buttonGroup.append(button);

                    buttonGroup.append(dropDownMenu);

                    actionButtonsDiv.append(buttonGroup);
                }
                else {
                    _.each(this.options.actionButtons, function (b) {
                        if (a4.evaluateCondition(b.DisplayCondition, node)) {
                            var actionButton = $("<span />", { "class": "action-button fa " + b.Icon, "title": b.Label, "data-action": b.Action });

                            actionButtonsDiv.append(actionButton);
                        }
                    });
                }

                listItem.append(actionButtonsDiv);
            }
        },
        _toggleNode: function (node, select) {
            if (node) {
                var stateNode = this._getNodeState(node.ListView_Internal_Key);

                if (stateNode) {
                    if (select == undefined) {
                        select = !stateNode.Selected;
                    }

                    stateNode.Selected = select;
                }

                if (node.Element && node.Element.length > 0) {
                    var nodeType = "Node";

                    if (node.Element.hasClass("root"))
                        nodeType = "Root";
                    else if (node.Element.hasClass("leaf"))
                        nodeType = "Leaf";

                    var nodeIcon = this._getNodeIcon(node, nodeType, false);
                    var selectedNodeIcon = this._getNodeIcon(node, nodeType, true);

                    node.Element.toggleClass("selected", select);

                    if (select) {
                        $(".v-nodeIcon", node.Element).removeClass(nodeIcon).addClass(selectedNodeIcon);
                    }
                    else {
                        $(".v-nodeIcon", node.Element).removeClass(selectedNodeIcon).addClass(nodeIcon);
                    }
                }

                if (select)
                    this.lastSelectedNode = node;

                this._trigger(select ? "selectNode" : "unselectNode", null, { node: _.omit(node, function (value, key, object) { return key.substring(0, 18) == "ListView_Internal_"; }), isCustom: node.ListView_Internal_IsCustom });
            }
        },
        _handleNodeClick: function (node, multiple) {
            var saveState = false;

            if (node) {
                if (this.options.multipleSelection) {
                    if (multiple && this.lastSelectedNode && this.lastSelectedNode.Element) {
                        var lastIndex = $("li.node", this.element).index(this.lastSelectedNode.Element);
                        var nodeIndex = $("li.node", this.element).index(node.Element);

                        for (var index = Math.min(lastIndex, nodeIndex) ; index <= Math.max(lastIndex, nodeIndex) ; index++) {
                            var element = $("li.node", this.element).get(index);
                            var nodeKey = $(element).attr("data-nodekey");
                            this._toggleNode(this._getNodeData(nodeKey), true);
                        }
                    }
                    else {
                        this._toggleNode(node);
                    }

                    saveState = true;
                }
                else {
                    var selectedNode = this.lastSelectedNode;
                    var selectedNodeKey;

                    if (selectedNode)
                        selectedNodeKey = selectedNode.ListView_Internal_Key;

                    if (node.ListView_Internal_Key != selectedNodeKey) {
                        //Unselect selected node
                        this._toggleNode(selectedNode, false);

                        //Select node
                        this._toggleNode(node, true);

                        saveState = true;
                    }
                    else if (this.options.allowUnselect) {
                        this._toggleNode(node, false);

                        saveState = true;
                    }
                }

                //Get selected nodes
                if (this.options.altValueField) {
                    var selectedNodeKeys = _.pluck(this.getSelectedNodes(), "ListView_Internal_Key");
                    this.options.altValueField.val(selectedNodeKeys.join());
                }

                if (saveState) {
                    this._saveState();
                }
            }
            else {
                this.lastSelectedNode = null;
                this._toggleNode(this.lastSelectedNode, false);
                this._trigger("clearTable", null, { node: {} });
            }
        },
        _loadState: function () {
            var self = this;
            return a4.callServerMethod(a4.getUrl("Shared/GetListViewConfiguration"), { type: this.options.stateKey, itemId: 0 }, function (result) {
                if (result && result.Nodes)
                    self.state = { Nodes: _.filter(result.Nodes, function (s) { return s.Key != null; }) };
                else
                    self.state = { Nodes: [] };

                self._trigger("loadState", null, { state: self.state });
            });
        },
        _saveState: function () {
            if (this.options.stateKey) {
                a4.callServerMethod(a4.getUrl("Shared/UpdateListViewConfiguration"), { type: this.options.stateKey, itemId: 0, config: this.state }, function (result) { });
            }
        },
        _search: function (value) {
            var self = this;
            var labelProperty = this.options.properties.Label;
            var nodes = this.data.Nodes;
            var expanded;

            if (value && value.length > 0) {
                nodes = [];

                var matcher = new RegExp($.ui.autocomplete.escapeRegex(value), "i");

                var filteredNodes = _.filter(this.data.Nodes, function (n) {
                    var isMatching = matcher.test(n[labelProperty]);
                    var isParentNode = n.ParentId === null;                     // Keep Parent node in result
                    return isMatching || isParentNode;
                });

                // Reject parent node that have no childs
                var filteredNodes = _.reject(filteredNodes, function (n) {
                    return _.filter(filteredNodes, function (m) { return m.ParentId === n.Id; }).length === 0 && n.ParentId == null;
                });

                if (filteredNodes.length > 0) {
                    nodes = filteredNodes;
                    expanded = true;

                    if (nodes.length > filteredNodes.length) {
                        //Load parents for each node
                        _.each(filteredNodes, function (n) {
                            nodes = _.union(nodes, self._getParentNodes(n));
                        });

                        nodes = _.uniq(nodes, false, function (f) { return f.ListView_Internal_Key; });
                    }
                }
            }

            this._renderList(nodes, expanded);

            // Select the first parent node and load corresponding data
            var firstParentNode = _.find(nodes, function (n) { return n.ParentId == null; });
            if (firstParentNode != undefined) {
                this._handleNodeClick(_.find(this.data.Nodes, function (n) { return n.Id == firstParentNode.Id; }), false);
            }
            else {
                this._handleNodeClick(_.find(this.data.Nodes, function (n) { return n.Id == null; }), false);
            }
        },
        _bindEvents: function () {
            var self = this;

            this._on({
                "click span.h-toggle": function (event) {
                    var element = $(event.currentTarget);
                    var nodeElement = element.closest("li.node");
                    var key = nodeElement.attr("data-nodekey");
                    var node = self._getNodeData(key);

                    nodeElement.toggleClass("expanded");
                    $(".h-toggle", nodeElement).toggleClass("fa-caret-down fa-caret-right");

                    //Updating state

                    var nodeState = self._getNodeState(key);
                    nodeState.Expanded = !node.Expanded;

                    nodeElement.next("ul.sub-menu").toggle();
                    event.stopPropagation();
                    this._saveState();
                },
                "click li.node": function (event) {
                    var element = $(event.currentTarget);
                    var nodeKey = element.attr("data-nodekey");
                    this._handleNodeClick(self._getNodeData(nodeKey), event.shiftKey);
                },
                "click .h-actionButtons span": function (event) {
                    var element = $(event.currentTarget);
                    var nodeElement = element.closest("li.node");
                    var key = nodeElement.attr("data-nodekey");
                    var node = self._getNodeData(key);
                    var action = element.attr("data-action");

                    this._trigger("actionButtonClick", null, { node: node, action: action });
                    event.stopPropagation();
                },
                "click .h-searchButton": function (event) {
                    self._search($(".h-searchBox", self.element).val());
                },
                "keypress .h-searchBox": function (event) {
                    if (event.keyCode == 13) {
                        self._search($(".h-searchBox", self.element).val());
                    }

                    return event.keyCode != 13;
                }
            });
        }
    });
}(jQuery));